CPU 48	' Run the CPU at full speed until all the initialisation is done

Option Explicit
Option Default Integer 
Option Autorun On

' Display 128 / 160
' Sensor 11.5mA at 5V

' Display settings for information
' Const A0_Pin		= 24
' Const RESET_Pin	= 23
' Const CS_Pin		= 22
' Const Orientation	= 3

Const Battery_test 	= 0.95	' Percentage drop for low battery warning
Const Calibrate_pin	= 16	' RB7
Const VCC_hold_pin	= 2	' RA0
Const Data_pin		= 4	' RB0
Const Battery_pin	= 5	' RB1
Const Timeout		= 9000	' Timeout in milliseconds
Const Default_dry	= 0.1	' Dry reading initialisation
Const Default_wet	= 3.9	' Wet reading initialisation
Const Scale_points = 150	' Width of graphical scale

' Some general colours
Const orange = RGB(255,223,0)
Const chartreuse = RGB(239,255,0)
Const spring_green = RGB(0,255,239)
Const azure = RGB(0,239,255)
Const violet = RGB(239,0,255)
Const rose = RGB(255,0,239)
Const bright_blue = RGB(159,159,255)
Const bright_red = RGB(255,150,200)

Dim Dry_level as float = Default_dry	' Dry level threshold
Dim Wet_level as float = Default_wet	' Wet level threshold
Dim reading				' Pointer
Dim old_reading = -1			' Previous pointer
Dim index				' Pointer
Dim old_index = -1			' Previous pointer
Dim Calibrate = 5			' Delay before calibration in seconds
Dim Keep_time = timer			' Switch off timer
Dim moisture as float			' Analogue reading from probe
Dim Good_battery as float		' Good battery voltage
Dim a					' Working variable

' Textual displays and associated colours
Dim level(9) as string length 11 = ("Bone dry","Very dry","Dry","Damp","Moist","Moist"," Very moist ","Wet","Very wet","Saturated")
Dim colours(9) = (bright_red,orange,RGB(yellow),chartreuse,RGB(green),RGB(green),chartreuse,RGB(yellow),orange,bright_red)

' Initialise the pins
Setpin VCC_hold_pin,DOUT
Pin(VCC_hold_pin) = 1			' Latch Q1 to keep power on
Setpin Data_pin, AIN
Setpin Battery_pin, AIN
Setpin Calibrate_pin, DIN, PULLUP

Var restore				' Restore saved variables

' Test for calibration
if Pin(Calibrate_pin) = 0 then
	Dry_level = Default_dry		' Set defaults and save variables
	Wet_level = Default_wet
	Good_battery = pin(Battery_pin)
	var save Dry_level, Wet_level, Good_battery

	cls				' Display 'Reset' wait 1 second then power off
	text 80,0,"Reset","CT",1,2,rgb(white)
	pause 1000
	Setpin VCC_hold_pin,OFF
end if

' Test for good battery
if pin(Battery_pin) < Good_battery * Battery_test then
	cls				' Display 'Battery low' wait 2 seconds and power off
	text 80,0,"Battery","CT",1,2,rgb(white)
	text 80,30,"low","CT",1,2,rgb(white)
	pause 2000
	Setpin VCC_hold_pin,OFF
end if

' Display the fixed graphics boxes
cls
for a = 0 to 9
	box a*15 + 5,60,15,30,1,rgb(white),colours(a)
next a

CPU 5	' Now we are all initialised, reduce CPU speed to save power
do while 1
	' Check if it's time to switch off
	If Timer - Keep_time > Timeout then
		Setpin VCC_hold_pin,OFF
	end if

	moisture = Pin(Data_pin) ' Read the current moisture level

	' If the calibration period has expired and the reading is dryer than previously, update dry level
	if (moisture > Dry_level) and (Calibrate <= 0) then
		Dry_level = moisture + 0.0001
		var save Dry_level
	end if

	' If the calibration period has expired and the reading is wetter than previously, update wet level
	if (moisture < Wet_level) and (Calibrate <= 0) then
		Wet_level = moisture - 0.0001
		var save Wet_level
	end if

	' Calculate what text to display (scale of 0 to 9)
	index = 9 - int((moisture - Wet_level) / (Dry_level - Wet_level) * 10)
	if index < 0 then index = 0
	if index > 9 then index = 9

	' Update only if the text has changed
	if old_index <> index then 
		text 80,0,"          ","CT",1,2,rgb(black)	' delete previous text
		text 80,0,level(index),"CT",1,2,colours(index)	' New text
		old_index = index
	end if

	' Calculate percentage and position of pointer
	reading = scale_points - ((moisture - Wet_level) / (Dry_level - Wet_level) * Scale_points)
	if reading < 0 then reading = 0
	if reading > scale_points then reading = scale_points

	' Update only if there has been a change
	if old_reading <> reading then
		' Display percentage
		if cint(reading / Scale_points * 100 ) < 999 then
			text 72,30,str$(cint(reading / Scale_points * 100 ),3) + "%","CT",1,2,colours(index)
		end if

		' Update pointer arrow
		box old_reading + 1,94,8,33,1,rgb(black),rgb(black)	' Delete old pointer arrow

		' Display new pointer arrow
		box reading + 4,94,2,2,1,rgb(white),rgb(white)
		box reading + 3,96,4,2,1,rgb(white),rgb(white)
		box reading + 2,98,6,2,1,rgb(white),rgb(white)
		box reading + 1,100,8,27,1,rgb(white),rgb(white)
		old_reading = reading
	end if

	calibrate = calibrate - 1	' Update calibration pointer
	pause 1000			' Sleep for 1 second
loop
